<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- 
Folgende Seiten zum testen:
http://www.w3schools.com/xsl/tryxslt.asp?xmlfile=cdcatalog&xsltfile=cdcatalog
http://xslt.online-toolz.com/tools/xslt-transformation.php
-->
<xsl:template match="/" name="main">
  <xsl:variable name="amount" select="count(//cd)"/>
  <html>
    <body>
      <h2><xsl:value-of select="catalog/@propertyOf"/>'s CD <xsl:value-of select="name(*)"/></h2>
      <h3>Amount: <xsl:value-of select="$amount"/></h3>
      <table border="1">
       <tr bgcolor="lightgrey">
        <th>Title</th>
        <th>Artist</th>
        <th>Price</th>
       </tr>
       <xsl:for-each select="catalog//cd">
        <tr>
         <td><xsl:value-of select="title"/></td>
         <td><xsl:value-of select="artist"/></td>
         <td><xsl:call-template name="tooExpensiveForYou">
<xsl:with-param name="newPrice"><xsl:value-of select="number(price)+10"/></xsl:with-param>
              </xsl:call-template></td>
        </tr>
       </xsl:for-each>
      </table>
    </body>
  </html>
</xsl:template>

<xsl:template name="tooExpensiveForYou">
 <xsl:param name="newPrice"/>
 <xsl:choose>
  <xsl:when test="$newPrice > 20">It's too expensive for you!</xsl:when>
  <xsl:otherwise><xsl:value-of select="$newPrice"/>0 $</xsl:otherwise>
 </xsl:choose>
</xsl:template>

<xsl:template match="cd">
        <tr>
        <td><xsl:value-of select="title"/></td>
        <td><xsl:value-of select="artist"/></td>
        <td><xsl:value-of select="price"/></td>
       </tr>
</xsl:template>

</xsl:stylesheet>
