package floweditor.pool.MODEL.WORKFLOW;

import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;

import java.lang.NumberFormatException;

import java.util.Enumeration;

import javax.swing.JTextField;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;

import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.LocationVerifyer;
import floweditor.util.Log;

/** Klasse, die Textfield darstellt, auf der den Wert des Attributes
 *  DURATION eingetragen bzw. dargestellt wird. 
 */
public class AttrDURATION
    extends javax.swing.JTextField
    implements CompEventHandler, FocusListener
{
    Component _owner;
    AttDef    _attDef;
    boolean   _isValid;
    LocationVerifyer _verifier = new LocationVerifyer ();

    protected AttrDURATION (Component owner, AttDef attDef, int columns) 
    {
        super (columns);
        _owner  = owner;
        _attDef = attDef;
        _isValid = false;

        String attributeName  = _attDef.getName ();
        String attributeValue = _owner.getAttribute (attributeName);

        this.setText (attributeValue);
        this.addFocusListener (this);
        Log.file(1,"APPLICATIONS:", "AttrDURATION (..)",
                 attributeName + "::" + 
                 attributeValue);
    }
   
    public  void childRemovedEvent(Component owner, 
                                   Component child, 
                                   int index)
    {
        // ignore       
    }

    public  void childInsertedEvent(Component owner, 
                                    Component child, 
                                    int index)
    {
        // ignore
    }

    public  void attributeChangedEvent(Component owner, 
                                       String attrname, 
                                       String value)
    {
        Log.file(2,"AttrDURATION", "attributeChangedEvent(..)");
        if ((_owner == owner) && (attrname == _attDef.getName())){
            this.setText(value);
        }
    }

    /**
     *  berprft, ob eingegebenen Wert tatschlich eine (positive) 
     *  Zahl darstellt. Der Wert dieses Attributes ist abhngig von dem
     *  Wert fr DURATION-UNIT */ 
    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	String attrValue = this.getText ();
	int    unit_value;
	/* No argument given, nothing to check (attribute is optional) */
	if (attrValue == null || ((attrValue.trim()).length () == 0)) 
	    return;
	else { /* check argument, is it a number?*/
	    try {
		unit_value = Integer.parseInt (attrValue);
		if (unit_value <= 0) 
		    _isValid = false;
		else 
		    _isValid = true;
	    } catch (NumberFormatException exc) {		
		throw new NotWellFormedDocument ("WORKFLOW.AttrDURATION \n" +
						 "Error: bad argument for "+
                                                 "duration! \n" +
                                                 "Please enter a positive number" +
                                                 "corresponding your chosen" +
                                                 "duration unit",
						 _owner);
	    } /* end try */
	} /* end if */
	if (!_isValid) 
	    throw new NotWellFormedDocument ("WORKFLOW.AttrDURATION \n" +
					     "Error: bad argument for duration!\n"+
                                             "Please enter a positive number",
					     _owner);
    }

    //////////////////////////////////////////////
    //       Implementation of FocusListener    //
    //////////////////////////////////////////////
    public void focusGained (FocusEvent event)
    {

    }

    public void focusLost (FocusEvent event)
    {
        String attributeName  =  _attDef.getName();
        String attributeValue = this.getText();

        if ((attributeValue.trim ()).length () == 0)
            _owner.setAttribute (attributeName, null);
        else
	    _owner.setAttribute (attributeName, attributeValue);
        _owner.changeAttributeEvent ((CompEventHandler) this, 
                                     attributeName, 
                                     attributeValue);   
        Log.file (3,"WORKFLOW::AttrDURATION", 
                  "focusLost(FocusEvent)",
                  "attrvalue = " + attributeValue);
    }
}
