package floweditor.pool.MODEL.TRANSITIONRESTRICTION;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Enumeration;
import javax.swing.JComboBox;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;

import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;


/** Klasse, die ComboBox darstellt, auf der den Wert fr das Attribut
 *  SPLIT eingetragen bzw, ausgewhlt wird.*/
public class AttrSPLIT
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    AttDef    _attDef;
    boolean   _isValid;
    static String  NOVALUE = "none";

    /** */
    protected AttrSPLIT (Component owner, AttDef attDef, int columns) {
	// FIXME
	super();
	_owner = owner;
	_attDef = attDef;
	_isValid = false;
	
	String  attributeName   = _attDef.getName();
	String  attributeValue  = _owner.getAttribute(attributeName);
	String  attDefaultValue = _attDef.getDefaultStringValue();
	
        Log.file (1,"AttrSPLIT","AttrSPLIT (..) ", 
                  attributeName + "::" + 
                  attributeValue); 

	/* If attribute not required (attrtype == implied),
	   add Dummy-Field */
	this.addItem (NOVALUE);

	Enumeration enum = attDef.elements();
	while(enum.hasMoreElements()) {
	    String item = (String) enum.nextElement();
	    _isValid = _isValid || (item.equals(attributeValue));
	    this.addItem(item);
	}
	if (_isValid) {
	    this.setSelectedItem(attributeValue); 
	} else if (attDefaultValue != null) {
	    this.setSelectedItem(attDefaultValue); 
	} else {
	    this.setSelectedIndex(0); 
	}

	this.addActionListener( new ActionListener () {
		public void actionPerformed(ActionEvent e) {
		    AttrSPLIT combobox = AttrSPLIT.this;
		    Component component = combobox._owner;
		    String     attrName = (combobox._attDef).getName();
		    String attrValue 
			= (String) combobox.getSelectedItem();
		    /* attribute got no value (only possible when 
		       attrType == IMPLIED) */
		    if (attrValue == NOVALUE) { 
			// no value for this attribute
                        component.setAttribute (attrName, null);
		    }
		    else 
			component.setAttribute(attrName, attrValue);
		    component.changeAttributeEvent((CompEventHandler) combobox , 
						   attrName, 
						   attrValue);
		}
	    }   );

    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	Log.file(1,"AttrSPLIT", "attributeChangedEvent(..)");
	if ((_owner == owner) && (attrname == _attDef.getName())){
	    this.setSelectedItem (value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	Log.file(1,"AttrSPLIT", "checkForconsistency(..)");
	String attrValue = (String) this.getSelectedItem ();
	/* FIXME 
	   ACTIVITY activity = _owner.getParent ();
	   if (activity.isJoin ()) 
	       if (attrValue.equals(NOVALUE))
	           throw new NotWellFormedDocument ("bad argument for Join! " +
		                                    "choose a value for this "+
	   					    "attribute ->Slit-Activity");
	   else 
	       if (!attrValue.equals(NOVALUE))
	          throw new NotWellFormedDocument ("bad argument for Join! " +
		                                   "choose dummy-value for this"+
	   					   " attribute" + 
						   " -> Activity-Typ != Split");
	*/
    }


}
