package floweditor.pool.MODEL.DATA;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Enumeration;

import javax.swing.JComboBox;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.TXElement;

import floweditor.component.CompFactory;
import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.LocationVerifyer;
import floweditor.util.Log;


/** Klasse, die Textfield darstellt, auf der den Wert des Attributes
 *  WORKFLOW eingetragen bzw. dargestellt wird. 
 */
public class AttrWORKFLOW
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    Component _workflow; //predecessor of owner (important only wenn Wkf-Component);
    Component _refComp;  // which Component is referenced by 
    String    _workflowID; 
    AttDef    _attDef;
    boolean   _isValid;

    LocationVerifyer _verifier = new LocationVerifyer ();
    String URI = "";
    
    /** */
    protected AttrWORKFLOW (Component owner, AttDef attDef, int columns) {
	// FIXME
	super();
	_owner = owner;
	_attDef = attDef;
	_isValid = false;
	this.setEditable (true);

	String  attributeName   = _attDef.getName();
	String  attributeValue  = _owner.getAttribute(attributeName);
	String  ownerName       = _owner.getTagName ();
	
	Log.file(1,"DATA:AttrWORKFLOW", 
                 "AttrWORKFLOW (Component, AttDef, String)",
                 attributeName + "::" + 
                 attributeValue);

	// find ancestor data 
	_workflow = (Component) _owner.searchAncestors ("WORKFLOW");
	if (_workflow != null) 
	    _workflowID = _workflow.getAttribute ("ID");
	else 
	    _workflowID = "";
	// Liste aller Komponenten der Sorte "DATA" in Dokument
        CompFactory factory = (CompFactory) _owner.getFactory ();
        Component    parent = (Component) factory.getChildAt (0);
        TXElement [] workflows  = parent.searchDescendantsAll ("WORKFLOW");
	
	/*  set workflow-idrefs as item in combobox
	 */
        for (int i = 0; i < workflows.length; i++) {
            String idValue = workflows [i].getAttribute ("ID");
            _isValid = _isValid || (idValue.equals (attributeValue));
            if ( !idValue.equals (_workflowID))
                this.addItem (idValue);
        }

	if (_isValid) {
	    this.setSelectedItem (attributeValue);
	    this.addItem (URI);
	} else {
	    URI = attributeValue;
	    this.addItem (URI);
	    this.setSelectedItem (URI);
	}

	this.addActionListener( new ActionListener () {
		public void actionPerformed(ActionEvent e) {
		    AttrWORKFLOW combobox   = AttrWORKFLOW.this;
		    Component component = combobox._owner;
		    String     attrName = (combobox._attDef).getName();

                    /* get entered/choosen value */
		    String    attrValue = (String) combobox.getSelectedItem ();

		    int selected = combobox.getSelectedIndex ();
		    /* uri entered */
		    if (selected == -1) 
		    {
			combobox.removeItem (URI);
			URI = attrValue;
			combobox.addItem (URI);
			combobox.setSelectedItem (URI);
		    } else { /*standard data-idref choosen */
			combobox.setSelectedItem (attrValue);
		    }

		    /* if attrvalue is an empty string, remove attribute */
                    if ((attrValue.trim ()).length () == 0)
                        component.setAttribute (attrName, null);
                    else 
			component.setAttribute (attrName, attrValue); 
		    component.changeAttributeEvent((CompEventHandler) combobox, 
						   attrName, 
						   attrValue);
		}
	    }   );
	
    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	Log.file(1,"AttrWORKFLOW", "attributeChangedEvent(..)");
	if ((_owner == owner) && (attrname == _attDef.getName())){
	    this.setSelectedItem (value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	Log.file (1, "DATA.AttrWORKFLOW", "checkForConsistency()", _owner);
	String attrValue = (String) this.getSelectedItem ();
	if ( attrValue.equals (URI)) {
	    if ( attrValue == null || 
		 (attrValue.trim()).length () == 0 ){
		throw new NotWellFormedDocument ("DATA.AttrWORKFLOW \n" +
						 "Error: No value entered " +
						 "for Workflow! \n" +
						 "Enter an URI or choose " +
						 "an ID",
 						 _owner);
	    } else {
		_isValid = _verifier.isWellFormedURI (attrValue);
		if (!_isValid) 
		    throw new NotWellFormedDocument ("DATA.AttrWORKFLOW \n" +
						     "Error: entered value is not" +
						     " a valid URI! \n" +
						     "Please enter a correct URI" +
						     " choose an ID",
						     _owner);
	    } 
	} else {
	    /* gibt's dieses Workflow-Element */
	    Component wkf = _owner.checkID (attrValue);
	    if (wkf == null) 
		throw new NotWellFormedDocument ("DATA.AttrWORKFLOW \n" +
						 "Error: WORKFLOW-Comp. with " +
						 "this ID doesn't exist! \n" +
						 "Choose another ID or " +
						 "enter a URI",
						 _owner);
		
	} /*end if(2) */
    }
    
}
