package floweditor.pool.MODEL.APPLICATION;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Enumeration;

import javax.swing.JComboBox;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.TXElement;

import floweditor.component.CompFactory;
import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.LocationVerifyer;
import floweditor.util.Log;


/** Klasse, die Textfield darstellt, auf der den Wert des Attributes
 *  PARAM eingetragen bzw. dargestellt wird. 
 */
public class AttrPARAM
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    Component _data; //predecessor of owner (important only wenn Data-Component);
    // FIXME
    Component _refComp;  // which Component is referenced by 
    String    _dataID; 
    AttDef    _attDef;
    boolean   _isValid;

    LocationVerifyer _verifier = new LocationVerifyer ();

    String URI = "";
    
    /** */
    protected AttrPARAM (Component owner, AttDef attDef, int columns) 
    {
	super();
	_owner = owner;
	_attDef = attDef;
        // FIXME who is't referenced Component?
        _refComp  =  null;
	_isValid = false;
	this.setEditable (true);

	String  attributeName   = _attDef.getName();
	String  attributeValue  = _owner.getAttribute(attributeName);
	String  ownerName       = _owner.getTagName ();
	
        Log.file (1,"AttrPARAM","AttrPARAM (..) ", 
                  ownerName + "::" +  
                  attributeName + "::" + 
                  attributeValue); 

	// find ancestor data 
	_data = (Component) _owner.searchAncestors ("DATA");
	if (_data != null) 
	    _dataID = _data.getAttribute ("ID");
	else 
	    _dataID = "";
	// Liste aller Komponenten der Sorte "DATA" in Dokument
        CompFactory factory = (CompFactory) _owner.getFactory ();
        Component    parent = (Component) factory.getChildAt (0);
        TXElement [] datas  = parent.searchDescendantsAll ("DATA");
	
	/*  set data-idrefs as item in combobox
	 */
        for (int i = 0; i < datas.length; i++) {
            String idValue = datas [i].getAttribute ("ID");
            _isValid = _isValid || (idValue.equals (attributeValue));
            if ( !idValue.equals (_dataID))
                this.addItem (idValue);
        }

	if (_isValid) {
	    this.setSelectedItem (attributeValue);
	    this.addItem (URI);
	} else {
	    URI = attributeValue;
	    this.addItem (URI);
	    this.setSelectedItem (URI);
	    System.err.println ("attribute value is URI = " + URI);
	}
	
	this.addActionListener ( new ActionListener () {
		public void actionPerformed(ActionEvent e) {
		    AttrPARAM combobox  = AttrPARAM.this;
		    Component component = combobox._owner;
		    String     attrName = (combobox._attDef).getName();

                    /* get entered/choosen value */
		    String    attrValue = (String) combobox.getSelectedItem ();

		    int selected = combobox.getSelectedIndex ();
		    /* uri entered */
		    if (selected == -1) 
		    {
			combobox.removeItem (URI);
			URI = attrValue;
			combobox.addItem (URI);
			combobox.setSelectedItem (URI);
		    } else { /*standard data-idref choosen */
			combobox.setSelectedItem (attrValue);
		    }

		    /* if attrvalue a empty string, remove attribute */
		    if ((attrValue.trim ()).length () == 0)
			component.setAttribute (attrName, null);
		    else 
			component.setAttribute (attrName, attrValue); 
		    component.changeAttributeEvent((CompEventHandler) combobox, 
						   attrName, 
						   attrValue);
		}
	    }   );

    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	Log.file(1,"AttrPARAM", "attributeChangedEvent(..)", _owner);
	if ((_owner == owner) && (attrname == _attDef.getName())){
	    this.setSelectedItem (value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	Log.file (1, "APPLICATION.AttrPARAM", "checkForConsistency()", _owner);
	String attrValue = (String) this.getSelectedItem ();
	if ( attrValue.equals (URI)) {
	    if ( (attrValue.trim()).length () != 0 ) {
		_isValid = _verifier.isWellFormedURI (attrValue);
		if (!_isValid) 
		    throw new NotWellFormedDocument ("APPLICATION:AttrPARAM \n" +
						     "Error: entered value is " +
                                                     "not a valid URI! \n" +
                                                     "Enter a URI or " +
						     "choose an ID ",
						     _owner);
	    }
	} else {
           Component param = _owner.checkID (attrValue);
           if (param == null)
               throw new NotWellFormedDocument ("APPLICATION.AttrPARAM\n" +
                                                "Error: DATA-Comp. with this ID " +
                                                "doesn't exist! \n" +
                                                "Choose another ID or " +
						"enter a URI",
                                                _owner);
	    
	}/*end if*/
    }
    

}
