package floweditor.component;

import java.awt.Dimension;
import java.awt.Color;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JTabbedPane;

public abstract class CompForm 
    extends Box 
{

    public CompForm () {
	super (BoxLayout.X_AXIS);
	_tabPane = new JTabbedPane ();
	_tabPane.setBackground (new Color (255, 218, 190));
	this.add(_tabPane);
    }

    public abstract void checkData ();

     public abstract void update ();

    public void setMinimumSize (Dimension dim) {
	_tabPane.setMinimumSize (dim);
    }
    
    public void addToTabPane(java.awt.Component comp, String titel) {
	_tabPane.add(comp, titel);
    }

    private JTabbedPane _tabPane;
}


