package floweditor.component;
import java.util.Enumeration;
import java.util.TreeMap;

import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.Comment;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Attr;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.DTD;

import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import floweditor.util.Log;

/** 
    
*/
public class CompFactory 
    extends com.ibm.xml.parser.TXDocument 
    implements javax.swing.tree.TreeNode, 
	       CompInterface
{
    private boolean _hasChanged; 


    /** */
    public CompFactory () {
	super ();
	_hasChanged = false;
    }

    /** @return true if document has changed since last readStream(),
        false else, after writeStream() turns to false. */
    public boolean documentHasChanged() {
	return _hasChanged;
    }
    
    /** must be called everytime one item changes within the document */
    public void setDocumentHasChanged() {
	_hasChanged = true; 
    }

    
    /**  Methode startet die rekursive Syntax- und Semantik-check
     *   in Dokumentbaum (Propagation nach unten).
     *   Aufgetretene Fehler werden weitergegeben an bergeordnete
     *   Klasse (propagieren nach oben)
     */
    public void checkForConsistency ()
	throws NotWellFormedDocument 
    {
	Component model = (Component) getChildAt (0);
	DTD dtd = this.getDTD ();
	if (dtd.validate (model) == null)	
	    model.checkForConsistency ();
	else 
	    throw new NotWellFormedDocument ("Syntax error occured: " +
					     "Element "+model.getTagName()+
					     " wrong defined." +
					     " Attribute or child node" +
					     " missing.\n" +
					     "Unable to save",
					     model);
    }

    //////////////////////////////////////////////////////////////////
    //                          TreeModel                           //
    //////////////////////////////////////////////////////////////////
    DefaultTreeModel _treeModel;
    
    public void setTreeModel(DefaultTreeModel treeModel) {
	_treeModel = treeModel;
    }

    public DefaultTreeModel getTreeModel() {
	return _treeModel;
    }

    //////////////////////////////////////////////////////////////////
    //                          TreeNode                            //
    //////////////////////////////////////////////////////////////////


    /** */
    public Enumeration children () {
	return elements ();
    }


    /** */
    public boolean getAllowsChildren () {
	return true;
    }


    /** */
    public TreeNode getChildAt (int childIndex) {
	if (childIndex==0) {
	    return (TreeNode) getDocumentElement ();
	} else {
	    return null;
	}
    }

    /** */
    public int getChildCount () {
	if (getDocumentElement () == null) {
	    return 0;
	} else {
	    return 1;
	}

    }


    /** */
    public int getIndex (TreeNode node) {
	if (getDocumentElement () == node) {
	    return 0;
	} else {
	    return -1;
	}
    }


    /** */
    public TreeNode getParent () {
	return (TreeNode) this;
    }


    /** */
    public boolean isLeaf () {
	return false;
    }  


    //////////////////////////////////////////////////////////////////
    //                          OTHER                               //
    //////////////////////////////////////////////////////////////////

//     /** berschreibt die Methode in @see TXDocument
//      *  */
//     public  org.w3c.dom.Attr createAttribute (String label) 
//  	throws org.w3c.dom.DOMException
//     {
// 	Log.file(1, "CompFactory", "createAttribute(String)");
// 	return new CompAttr(label, "");
//     }
    

    /** berschreibt die Methode in @see TXDocument, die Komponente
     *  @param label wird dynamisch geladen in Abhngigkeit der
     *  gelesenen DTD. Es wird erwartet, dass die entsprechenden
     *  Klassen in einem Pool zu finden sind. ZB: angenommen die DTD
     *  heisst MODEL, dann sollte sich die Klasse der Komponente
     *  ACTIVITY in folgendem Paket befinden:
     *  floweditor.pool.MODEL.ACTIVITY.* die Klasse nennt sich wie das
     *  oberste Paket, also lautet der vollstndig qualifizierte
     *  Klassen-Name floweditor.pool.MODEL.ACTIVITY.ACTIVITY Es
     *  gengt, die Klassen in den entsprechenden Verzeichnissen
     *  abzulegen. */
    public Element createElement (String label)
	throws org.w3c.dom.DOMException
    {
	Log.file(1, "CompFactory", "createElement(String)");
	Class newClass = null;
	final String modelName = getDTD().getName();
	
	//	System.err.println ("instanciation of class: " + label);

	try {
	    newClass = (Class) theLabelClassMap.get (label);
	} catch (Exception e) {
	    Log.file(2, "CompFactory","createElement(String)", 
		     "couldn load: " + label);
	    throw new DOMExceptionImpl (DOMExceptionImpl.NOT_FOUND_ERR, 
					e.getMessage());
	}

	// newClass == null implies label not in Map

        Component newElement = null;

	if (newClass == null) {
	    // load new Class

	    try {
		String classname 
		    =  "floweditor.pool."
		    + modelName + "."
		    + label + "." 
		    + label;
		Log.file(2, "CompFactory", "createElement(String)",
			 "load class " + classname );
		newClass = Class.forName (classname);
		// put into map
		theLabelClassMap.put (label, newClass);
		
	    } catch (Exception e) {
		Log.file(1, "CompFactory","createElement(String)", 
			 "couldn instanciate: " + label);
		throw new DOMExceptionImpl (DOMExceptionImpl.NOT_FOUND_ERR, 
					    e.getMessage());
	    }
	}
	try {
	    Log.file(2, "CompFactory", "createElement(String)","instanciate");
	    newElement = (Component) newClass.newInstance ();
	    newElement.setFactory (this);
	    //return newElement;
	} catch (Exception e) {
	    Log.file(1, "CompFactory", "createElement(String)",
		     "instanciate failed");
	    throw new DOMExceptionImpl (DOMExceptionImpl.NOT_FOUND_ERR, 
					e.getMessage());
	}	
    
	// if no error occured then newClass is labeled with reference to Object
	
	return newElement;

    }

    /** overrides method createTextNode in TXDocument
     */    
    public Text createTextNode (String data) {
	return new CompText (data);
    }

    /** overrides method createTextNode in TXDocument
     */    
    public TXText createTextNode (String data, boolean isIgnorableWhitespace) {
	if (isIgnorableWhitespace) { 
	    return null;
	} else {
	    return new CompText (data, isIgnorableWhitespace);
	}
    }

    /** overrides method createTextNode in TXDocument
     */ 
    public TXText createTextNode(char[] charArray, int offset,
				 int length, boolean isIgnorableWhitespace) {
	if (isIgnorableWhitespace) { 
	    return null;
	} else {
	    return new CompText (charArray, offset, length, isIgnorableWhitespace);
	}
    }

    /** overrides method createComment in TXDocument
     */ 
    public Comment createComment (String data) {
	return new CompComment (data);
    }


    /** */
    public String toString () {
	return "Active Document";
    }


    ////////////////////////////////////////////////////////////
    // Implementation of floweditor.component.CompInterface   //
    ////////////////////////////////////////////////////////////


    /** */
    public boolean isComponent () 
    {
	return false;
    }

    TreeMap theLabelClassMap = new TreeMap ();
}



