package floweditor.component;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.util.Hashtable;
import java.util.Enumeration;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.ibm.xml.parser.AttDef;

import floweditor.util.Log;

/** */
public class CompAttributeEditor 
    extends JPanel 
{    
    private Component _comp;        // besitzende Komponente     
    
    /**
     * list die DTD-Attributdefinition der Componente aus und erzeugt
     * dynamisch die entsprechenden Textfelder */
    public CompAttributeEditor (Component comp) 
    {
	super ();
	Log.file (1,"CompAttributeEditor","CompAttributeEditor(Component)");
	_comp = comp;

	this.setBackground (new Color (255, 218, 185));

	GridBagLayout      gbl = new GridBagLayout ();
	GridBagConstraints gbc = new GridBagConstraints ();
	this.setLayout (gbl);

	gbc.anchor    = GridBagConstraints.NORTHWEST;
	gbc.fill      = GridBagConstraints.HORIZONTAL;
	gbc.insets    = new Insets (5, 0 ,5, 0);
            
	String compName     = _comp.getTagName(); 
	/*  Behandlung fr Komponente, die PCDATA-Object (Text) enthalten */
	if (_comp.hasTextNode ()) {
	    try {
		JLabel compLabel     = new JLabel (compName + "  " + "TEXT ");
		JComponent textNodeField = _comp.createTextNodeField ();
		_comp.addCompEventHandler ((CompEventHandler) textNodeField);
		gbc.gridwidth = 1;
		this.add (compLabel, gbc);
		this.add (Box.createHorizontalStrut (5));
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		this.add (textNodeField, gbc);
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
	
	/* lese alle Attribute ein und erstelle die entsprechenden
	 * AttributFelder */
	Enumeration strEnum = _comp.getAttributeNames();
	while(strEnum.hasMoreElements()) {
	    try {
		AttDef     attDef    = (AttDef) strEnum.nextElement();
		String     attrName  = attDef.getName ();
		int        attrType  = attDef.getDeclaredType ();
		JLabel     label;

		if (attrName.equals ("WORKFLOW") ||
		    attrName.equals ("PARAM")) {
		    label = new JLabel (compName + " " + attrName +
					" (IDREF or URI)"); 
		} else {
		    label = new JLabel (compName + " " + attrName);
		}
		
		
		JComponent attrField = _comp.createAttributeField (attDef,
								   attrName); 

		_comp.addCompEventHandler ((CompEventHandler) attrField);

		gbc.gridwidth = 1;
		this.add (label, gbc);
		this.add (Box.createHorizontalStrut (5));
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		this.add (attrField, gbc);
		
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
    }


    /////////////////////////////////////////////////////////////
    //                CompEventHandler                         // 
    /////////////////////////////////////////////////////////////

    public void childRemovedEvent(Component owner, 
				  Component child, 
				  int index) 
    {
	// ignore
    }

    public void childInsertedEvent(Component owner, 
				   Component child, 
				   int index) 
    {
	// ignore
    }


    public void attributeChangedEvent(Component owner, 
				      String attrname, 
				      String value) 
    {
	/* das relevante Attribut-Textfeld muss mit dem neuen Wert
	 * aktualisiert werden
	 * */
	// suche Attribut-Textfeld
	// aktualisiere Wert ind er Anzeige
    }
    
    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {

    }

}
