package parser;

/**
 * JavaCodeTree is a utility class for the {@link parser.dSelfParser}.
 * When the parser generates Java code, this class collects the expressions
 * as strings in a tree form. This is more efficient than connecting
 * the string parts to one big string and makes it possible to split
 * the code into several methods. This is importent, when the code
 * gets bigger than the 64 kByte limit of the Java method. When this
 * happens, the code is splitted into as many methods as needed, which
 * are calling each other.
 */
public final class JavaCodeTree{

  /** An array for the nodes of the tree */
  protected Object[] nodes;
  
  /** Creates a new java code tree, with one node */
  public JavaCodeTree(Object o){
  
    nodes = new Object[1];
    nodes[0] = o;
  }
    
  /** Creates a new java code tree, with two nodes */
  public JavaCodeTree(Object o1, Object o2){
  
    nodes = new Object[2];
    nodes[0] = o1;
    nodes[1] = o2;
  }
    
  /** Creates a new java code tree, with three nodes */
  public JavaCodeTree(Object o1, Object o2, Object o3){
  
    nodes = new Object[3];
    nodes[0] = o1;
    nodes[1] = o2;
    nodes[2] = o3;
  }
    
  /** Creates a new java code tree, with four nodes */
  public JavaCodeTree(Object o1, Object o2, Object o3, Object o4){
  
    nodes = new Object[4];
    nodes[0] = o1;
    nodes[1] = o2;
    nodes[2] = o3;
    nodes[3] = o4;
  }
    
  /** Creates a new java code tree, with five nodes */
  public JavaCodeTree(Object o1, Object o2, Object o3, Object o4,
                      Object o5){
  
    nodes = new Object[5];
    nodes[0] = o1;
    nodes[1] = o2;
    nodes[2] = o3;
    nodes[3] = o4;
    nodes[4] = o5;
  }
    
  /** Creates a new java code tree, with six nodes */
  public JavaCodeTree(Object o1, Object o2, Object o3, Object o4,
                      Object o5, Object o6){
  
    nodes = new Object[6];
    nodes[0] = o1;
    nodes[1] = o2;
    nodes[2] = o3;
    nodes[3] = o4;
    nodes[4] = o5;
    nodes[5] = o6;
  }
    
  /** Creates a new java code tree, with seven nodes */
  public JavaCodeTree(Object o1, Object o2, Object o3, Object o4,
                      Object o5, Object o6, Object o7){
  
    nodes = new Object[7];
    nodes[0] = o1;
    nodes[1] = o2;
    nodes[2] = o3;
    nodes[3] = o4;
    nodes[4] = o5;
    nodes[5] = o6;
    nodes[6] = o7;
  }
    
  /** Creates a new java code tree, with nine nodes */
  public JavaCodeTree(Object o1, Object o2, Object o3, Object o4,
           Object o5, Object o6, Object o7, Object o8, Object o9){
  
    nodes = new Object[9];
    nodes[0] = o1;
    nodes[1] = o2;
    nodes[2] = o3;
    nodes[3] = o4;
    nodes[4] = o5;
    nodes[5] = o6;
    nodes[6] = o7;
    nodes[7] = o8;
    nodes[8] = o9;
  }

 /**
  * Returns the size of all strings connected to the tree at the nodes.
  */
  public int size(){
  
    int size=0;
    
    for(int i=0; i<nodes.length; i++)
      if(nodes[i] instanceof String)
        size += ((String)nodes[i]).length();
      else
        size += ((JavaCodeTree)nodes[i]).size();
	
    return size;  
  }  	

  /** An array for the code of the generated methods */
  protected static String[] methods = new String[100];
  /** A counter for the actual position in the method arry {@link #methods}*/
  protected static int pos = 0;

 /**
  * Generates a string with the code of the Java class, that represents 
  * the compiled dSelf script. The generated class inherits from 
  * dSelf.dSelfProgram and overwrites the {@link dSelf.dSelfProgram#getExpression()} 
  * method.
  *
  * @param className The name for the generated class
  * @param javaMethodSize The prefered size of methods (number of characters)
  * @return The generated Java class
  */
  public String getJavaClass(String className, int javaMethodSize){
  
    StringBuffer code = new StringBuffer(50000);
    
    code.append(
      "import dSelf.*;\n" +
      "import parser.*;\n" +
      "\n" +
      "public class " + className + " extends dSelfProgram {\n" +
      "\n" +
      "  public CodeExpr getExpression(){\n" +
      "\n" +  
      "    return (CodeExpr)" + 
      toCodeString(javaMethodSize) + ";\n" +
      "  }\n");
      
    for(int i=0; i<pos; i++)
      code.append(methods[i] +"\n\n");

    code.append("}\n");  
    
    return code.toString();
  }
  
 /**
  * Generates the methods of the Java class and stores each in the 
  * class variable {@link #methods}.
  *
  * @param length The prefered size of methods (number of characters)
  * @return The first method, that will be put into the method
  * {@link dSelf.dSelfProgram#getExpression()} 
  */ 
  protected String toCodeString(int length){
  
    String str = "";

    for(int i=0; i<nodes.length; i++)
      str += (nodes[i] instanceof String) ? 
           (String)nodes[i] : ((JavaCodeTree)nodes[i]).toCodeString(length);
    
    if(str.length() > length){

      if(pos >= methods.length){

        String[] dummy = methods;
	methods = new String[pos+100];

	for(int i=0; i<pos; i++)
	  methods[i] = dummy[i];
      }
        
      methods[pos] = "  Object getObj" + pos + "(){\n\n" +
                "    return " + str + ";\n  }\n";
      str = "(getObj" + pos + "())";	
      pos++;
      System.out.print(".");
    }  
      
    return str;      
  }      
}

