package dSelf;

import java.util.Vector;
import java.io.*;
import dSelfVM;

/**
 * TerminalFrontEnd is a front-end for the dSelf virtual mavhine,
 * that runs on the terminal. 
 */
public class TerminalFrontEnd implements VMFrontEnd{
  
  /** A counter, that counts the inputs of the user */
  protected static int promptCounter = 0;

  /**
   * Starts this front-end. It welcomes the user and waits for input.
   */
  public void Run(Vector filenames){

    if (dSelfVM.verboseMode)
      System.out.print("\n\nWelcome to dSelf !\n\n");

    for (int i=0; i<filenames.size(); i++) {
      String result = dSelfVM.evalInput("'" + (String)filenames.get(i) + "' _RunScript");

      if(result != null)
        System.out.println("-> "+result);
    }
      
    while(true){
      shellPrompt();
    }  
  }      
 
 /**
  * Shows a prompt to the user and receives his input by calling
  * {@link #readInput()}.
  */
  protected void shellPrompt(){
  
    System.out.print("\n#dSelf["+promptCounter+"]> ");

    String result = dSelfVM.evalInput(readInput());

    if(result != null){
      promptCounter++;
      if(!result.equals(""))
        System.out.println("-> "+result);
    }  
  }  
  
 /**
  * Reads the input of the user. It reads the characters unless 
  * a carriage return was received and the number of the left 
  * parenthesis equals to the number of right parenthesis. Because
  * of this, it's possible to split a long object declaration over
  * several lines.
  *
  * return The input of the user
  */ 
  protected String readInput(){

    StringBuffer line = new StringBuffer();
    StringBuffer completeInput = new StringBuffer();
    
    do{  
      try{
        char ch = '\0'; 

        while(ch != '\n'){
          ch = (char) System.in.read();
          line.append(ch);
        }
      }
      catch(IOException ioE){
        System.out.println("I/O-Exception:" + ioE.getMessage());
      }  
      
      completeInput.append(line);
      line = new StringBuffer();

      if(hasOpenParenthesis(completeInput.toString())) 
        System.out.print("           ");
    }
    while(hasOpenParenthesis(completeInput.toString()));
      
    return completeInput.toString();
  }
  
 /**
  * Checks, if every left parenthesis has a matching right parenthesis.
  * Parenthesises in comments and strings are ignored, because they are
  * not part of syntactical parenthesis.
  *
  * @return True, if there are still unmatched left parenthesises
  */ 
  private boolean hasOpenParenthesis(String str){

    int parenthesis = 0;
    boolean inString = false;
    boolean inComment = false;
          
    for(int i=0; i<str.length(); i++){
      switch(str.charAt(i)){

	case '(': 
	  if(!inString && !inComment)
	    parenthesis++; 
          break;

        case ')':    
	  if(!inString && !inComment)
	    parenthesis--;
	  break;
	             
	case '\'':
	  if(!inComment)
  	    inString = !inString;
	  break;

	case '\"':
	  if(!inString)
	    inComment = !inComment;
	  break;
	  
	case '\\':
	  if(inString || inComment)
	    i++;
	  break;
      }
    }	

    return parenthesis > 0;
  }

 /**
  * Prints a message on the standard output device.
  */
  public void printMessage(String msg){
  
    System.out.println(msg);
  }
}
