package dSelf;

import java.util.Vector;
import java.io.Serializable;
import dSelfVM;

/**
 * SlotDeclarations consists of the slot declarations of data and
 * method objects.
 */
public class SlotDeclarations implements Serializable{
 
  /** A vector with all slot declarations of this object. */
  protected Vector slotDeclarations = new Vector();

  /** 
   * The annotation of the object, that will become the owner of 
   * these declarations.
   */
  protected String objectAnnotation;
  
 /** 
  * Creates a new empty slot declarations object. 
  */ 
  public SlotDeclarations(){}
  
 /** 
  * Creates a new slot declarations object with the given slots. 
  */ 
  public SlotDeclarations(SlotDecl slotDecl){
  
    slotDeclarations.add(slotDecl);
  }

 /**
  * Returns a vector with the declarations of this object.
  */
  public Vector getSlotDecls(){
  
    return slotDeclarations;
  }
  
 /**
  * Returns this object with the given annotation.
  *
  * @param anno The annotation for this object
  */ 
  public SlotDeclarations withObjectAnnotation(String anno){
  
    objectAnnotation = anno; 
    return this;
  }
  
 /**
  * Returns the annotation of this object.
  */   
  public String getObjectAnnotation(){
  
    return objectAnnotation;
  }

 /**
  * Adds some slot declarations to the existing ones.
  *
  * @param slotDecls The new slot declarations
  */
  protected void addSlotDeclarations(SlotDeclarations slotDecls){

     for(int i=0; i<slotDecls.getSlotDecls().size(); i++)
       addSlotDecl((SlotDecl)slotDecls.getSlotDecls().get(i));
  }

 /**
  * Adds some slot declarations to the existing ones and returns them.
  *
  * @param slotDecls The new slot declarations
  * @return This object with the new declarations
  */
  public SlotDeclarations withSlotDeclarations(SlotDeclarations slotDecls){

     addSlotDeclarations(slotDecls);  
     return this;
  }
       
 /**
  * Adds a slot declarations to the existing ones. If the name of the
  * new slot already exists, then an error message is printed.
  *
  * @param slotDecl The new slot declaration
  */
  public void addSlotDecl(SlotDecl slotDecl){
    
    for(int i=0; i<slotDeclarations.size(); i++){
      if(slotDecl.getSlotName().equals(
          ((SlotDecl)slotDeclarations.get(i)).getSlotName())){
	dSelfVM.printCompiletimeError("Slot \""+ slotDecl.getSlotName()+
	    "\" was declared twice !");
        return;
       }	 
    }
    slotDeclarations.add(slotDecl);
  }
     	         
 /**
  * Adds a slot declarationa to the existing ones and returns them.
  *
  * @param slotDecl The new slot declaration
  * @return This object with the new declaration
  */
  public SlotDeclarations withSlotDecl(SlotDecl slotDecl){
    
    addSlotDecl(slotDecl);
    return this;
  }  
  
 /**
  * Sets the given annotation for all slots.
  *
  * @param anno The annotation for the slots
  * @return This object with the set annotations
  */ 
  public SlotDeclarations withAnnotations(String anno){
    
    for(int i=0; i<slotDeclarations.size(); i++)
      ((SlotDecl)slotDeclarations.get(i)).setAnnotation(anno);
  
    return this;
  }
  
 /**
  * Returns a vector with all declarations of argument slots of this
  * object. 
  */ 
  public Vector getArgumentSlotDecls(){
  
    Vector result = new Vector();
    
    for(int i=0; i<slotDeclarations.size(); i++)
      if(((SlotDecl)slotDeclarations.get(i)).isArgumentSlot())
        result.add(slotDeclarations.get(i));
  
    return result;
  }  	  
}
