package dSelf;

/**
 * SerializedBlockSO repesents the serialized version of a dSelf block.
 */
public class SerializedBlockSO implements SerializedSO{

  /** The serialized block method object. */
  protected SerializedMethodSO serializedMethod;
  
 /**
  * Creates a new serialized block object with the given 
  *
  * @param block The block, that shall be serialized
  * @param server The server, that will send the slot vector
  */ 
  public SerializedBlockSO(BlockSO block, Server server){
  
    serializedMethod = new SerializedMethodSO(block.getMethod(), server);
  }

 /**
  * Returns the block, that was serialized.
  *
  * @param remoteVM The server of the dSelf VM, that received this 
  * slot vector.
  */   
  public BlockSO getBlock(ServerInterface remoteVM){
  
    return new BlockSO(serializedMethod.getMethod(remoteVM));
  }
}
         
