package dSelf;

import java.util.Hashtable;
import java.net.MalformedURLException;
import java.rmi.*;

/**
 * RemoteVMs collects the names of all known remote dSelf virtual machines.
 */
public class RemoteVMs{

  /** A hashtable with all known remote dSelf VMs. */
  protected Hashtable remoteServers = new Hashtable();
  
  /** Creates a new collection of remote dSelf VMs. */
  public RemoteVMs(){}
  
 /**
  * Adds the name of a remote dSelf VM. If this VM is already known,
  * then a reference to its server is returned. Otherwise a new
  * connection to its server is created and returned.
  *
  * @param name The name of the remote dSelf VM
  * @return A reference to the remote dSelf server 
  */ 
  public ServerInterface addServer(String name) throws dSelfException{
  
    try{
      ServerInterface server = (ServerInterface) remoteServers.get(name);
      return server != null ? server : (ServerInterface) Naming.lookup(name);  
    }  
    catch(NotBoundException e){
      throw new dSelfException(
          "A VM with this name is not bound to the registry !");
    } 
    catch(MalformedURLException e){
      throw new dSelfException(
         "The given URL is malformed !");
    }
    catch(RemoteException e){
      throw new dSelfException(
         "The registry of the demanded VM cannot be contacted !");
    }	 
  }
}
 
