package dSelf;

import java.rmi.*;
import dSelfVM;

/**
 * LocalAssignmentSO represents an assignment object, that is
 * located on another virtual machine. It realizes a remote reference
 * to this assignment object and forwards all messages to it.
 */
public class RemoteAssignmentSO extends AssignmentSO{

  /** The server of the remote dSelf virtual machine. */
  protected ServerInterface remoteVM = null;

 /** 
  * The ID of the remote assignment object, that is registered
  * at the remote server.
  */
  protected int remoteID;

 /**
  * Creates a new reference to a remote assignment object.
  *
  * @param vm The server of the remote dSelf virtual machine
  * @param ID The ID of the remote assignment object, that is registered
  * at the remote server 
  */ 
  public RemoteAssignmentSO(ServerInterface vm, int ID){

    remoteVM = vm;
    remoteID = ID;
  }

 /**
  * When this object is removed, it removes its corresponding reference
  * at the server of the remote dSelf virtual machine.
  */
  protected void finalize() throws RemoteException{

    remoteVM.removeRemoteReference(remoteID);
  }

 /**
  * Sets the new content of the slot, to which this assignment object
  * refers.
  *
  * @param content The data object for the data slot
  */ 
  protected void setContent(DataSO content){

    SerializedSO obj = null;
    
    // If the found object is an ordinary object, an object vector or
    // an assignment object then we create a reference to it.
    if(content instanceof OrdinarySO)
      obj = new SerializedOrdinarySO(
        dSelfVM.server.addRemoteReference((RemoteReferenceSO)content));
         
    // All primitive objects except object vectors and blocks are 
    // serializable without special handling
    if(content instanceof PrimitiveSO)
      if(content instanceof ObjectVectorSO)
        obj = new SerializedObjectVectorSO(
            dSelfVM.server.addRemoteReference((RemoteReferenceSO)content));
      else if(content instanceof BlockSO)
        obj = new SerializedBlockSO((BlockSO)content, dSelfVM.server);
      else
        obj = (SerializedSO)content;
    

    try{
      remoteVM.setContentOf(remoteID, dSelfVM.VMName, obj); 
    }catch(Exception e){
      handleException(e);
    }  
  }
}
