package dSelf;

import java.util.LinkedList;
import java.util.ListIterator;

public class PolymorphicInlineCache implements java.io.Serializable {
  
  private static class CacheItem {
    Genes g;
    LookupResult lr;

    CacheItem(Genes g, LookupResult lr) {
      this.g = g;
      this.lr = lr;
    }

    public String toString() {
      return "{" + g + "=" + lr + "}";
    }
  }
    
  /** max degree of PIC, i.e., receiver can have this degree of
   * different genes at most.*/
  private int maxDegree = 5;

  private LinkedList lruQueue = new LinkedList();

  public PolymorphicInlineCache() {}

  public PolymorphicInlineCache(int degree) {
    this.maxDegree = degree;
  }

  protected LookupResult get(Genes g) {
    ListIterator iter = lruQueue.listIterator();
    CacheItem item = null;
    LookupResult result = null;
    int i = 0;

    while (iter.hasNext()) {
      item = (CacheItem)iter.next();
      if (item.g.equals(g)) {
	if (item.lr.getHolder() instanceof MethodActivationSO
	    && ! ((MethodActivationSO)item.lr.getHolder()).isValid()) {
	  iter.remove();
	}else {
	  result = item.lr;
	  if (i>0)
	    iter.remove();
	}
	
	break;
      }
      i++;
    }

    if (result != null && i>0)
      lruQueue.addFirst(item);

    return result;
  }

  protected void put(Genes g, LookupResult lr) {
    lruQueue.addFirst(new CacheItem(g, lr));

    while (lruQueue.size() > maxDegree)
      lruQueue.removeLast();
  }
  
  public String toString() {
    return lruQueue.toString();
  }

  private void writeObject(java.io.ObjectOutputStream out)
    throws java.io.IOException {
    out.writeInt(maxDegree);
  }

  private void readObject(java.io.ObjectInputStream in)
    throws java.io.IOException, ClassNotFoundException {
    maxDegree = in.readInt();
    lruQueue = new LinkedList();
  }
  
}
