package dSelf;

import java.util.Vector;
import dSelfVM;

/**
 * OrdinarySOExpr represents the expression for an ordinary data object.
 */
public class OrdinarySOExpr extends SlottedSOExpr implements CodeExpr{

 /**
  * Creates a new ordionary data object expression with the given
  * slot declarations.
  *
  * @param slotDecls The slots of this object
  */ 
  public OrdinarySOExpr(SlotDeclarations slotDecls){
  
    slotDeclarations = slotDecls;

    Vector args = slotDeclarations.getArgumentSlotDecls();
    
    if(args.size() > 0)
      for(int i=0; i<args.size(); i++)
        dSelfVM.printCompiletimeError("Argument slot\""+
	    ((SlotDecl)args.get(i)).getSlotName()+"\" "+
            "cannot be declared in a data object ! "); 
  }

 /**
  * Creates an empty ordionary data object expression.
  */ 
  public OrdinarySOExpr(){
  
    slotDeclarations = new SlotDeclarations();
  }
  
 /**
  * Evaluates the slots of this object. It is used as the initializer
  * for data objects.
  *
  * @return A slot vector with the evaluated slots.
  */ 
  public DataSO eval(DataOrMethodSO dSO) 
      throws dSelfException, NonLocalReturnException{
   
    return new LocalOrdinarySO(evalSlots(), 
        slotDeclarations.getObjectAnnotation());    
  }
}
