package dSelf;

import java.util.Vector; 

/**
 * OrdinaryMsg represents the non primitive messages of dSelf. 
 */
public class OrdinaryMsg extends Message{   

  /** The selector of this message. */
  protected String selector = "";
  
  /** The receiver if this message is resend. */
  protected String resendTo = null;

 /**
  * Creates a new ordinary message with the given selector.
  *
  * @param sel The selector of this message
  */ 
  public OrdinaryMsg(String sel){

    selector = sel;
  }

 /**
  * Creates a new ordinary message with the given selector and 
  * arguments.
  *
  * @param sel The selector of this message
  * @param args The arguments of this message
  */ 
  public OrdinaryMsg(String sel, Vector args){

    selector = sel;
    messageArguments = args;    
  }

 /**
  * Creates a new ordinary message with the given selector, that is
  * resend.
  * @param sel The selector of this message
  * @param res The receiver of the resent message
  */ 
  public OrdinaryMsg(String sel, String res){

    selector = sel;
    resendTo = res;
  }

 /**
  * Creates a new ordinary message with the given selector and 
  * arguments, that is resent.
  *
  * @param sel The selector of this message
  * @param args The arguments of this message
  * @param res The receiver of the resent message
  */ 
  public OrdinaryMsg(String sel, Vector args, String res){

    selector = sel;
    messageArguments = args;    
    resendTo = res;
  }

 /**
  * Checks if this message is resend.
  */  
  public boolean isResend(){
  
    return resendTo != null;
  }  
  
 /**
  * Checks, if this message is an indirected resend.
  */ 
  public boolean isIndirectedResend(){
  
    return (resendTo != null && resendTo.equals(""));
  }  

 /**
  * Checks, if this message is a directed resend.
  */ 
  public boolean isDirectedResend(){
  
    return !isIndirectedResend();
  }  
  
 /**
  * Returns the resend receiver of this message.
  */ 
  public String getResendReceiver(){
  
    return resendTo;
  }
  
 /**
  * After calling this method, this message isn't a resend-message,
  * if it was one before.
  */ 
  public void setNoMoreResend(){
  
    resendTo = null;
  }
  
 /**
  * Returns the selector of this message.
  */   
  public String getSelector(){
  
    return selector;
  } 
}
