package dSelf;

/**
 * NonLocalReturnExpr represents an expression, that realizes a non
 * local return. 
 */
public class NonLocalReturnExpr implements CodeExpr{

 /**
  * The expression, that causes the non local return.
  */
  protected CodeExpr expression;
  
 /** 
  * Creates a new non local return with the given expression.
  */ 
  public NonLocalReturnExpr(CodeExpr e){
  
    expression = e;
  }
 
 /**
  * Evaluates this expression within the given context. It throws an
  * non local return exception with the result of the method, where
  * this expression is embedded.
  *
  * @param selfContext The context, in which this expression is evaluated.
  */ 
  public DataSO eval(DataOrMethodSO selfContext) throws dSelfException, NonLocalReturnException{
  
    throw new NonLocalReturnException(expression.eval(selfContext), ((MethodActivationSO)selfContext).findReturnTarget());
  }
}    
