package dSelf;

/**
 * MethodSlotDecl represents the declaration of a method slot. It is used 
 * by the parser.
 */
public class MethodSlotDecl extends SlotDecl{

  /** The content of this slot. */
  protected MethodSOExpr methodExpr;
  
 /**
  * Creates a new method slot declaration with the given name and content.
  *
  * @param name The name for this slot
  * @param mExpr The content of this slot
  */
  public MethodSlotDecl(String name, MethodSOExpr mExpr){
  
    slotName = name;
    methodExpr = mExpr;
  }
  
 /**
  * Evaluates the content of this slot in the context of the lobby.
  *
  * @return The evaluated content of this method slot
  */ 
  public MethodSO evalSlot() throws dSelfException, NonLocalReturnException{
  
    return methodExpr.eval();
  }    
   
 /**
  * Checks, if this slot is a parent slot.
  *
  * @return Returns always false, because methods can't be parents.
  */ 
  public boolean isParentSlot(){
  
    return false;
  }
  
 /**
  * Checks, if this slot is assignable.
  *
  * @return Returns always false, because methods aren't assignable.
  */ 
  public boolean isAssignableSlot(){
  
    return false;
  }
  
 /**
  * Checks, if this slot is an argument slot.
  *
  * @return Returns always false, because methods can't be arguments.
  */ 
  public boolean isArgumentSlot(){
  
    return false;
  }
}  
