package dSelf;

import java.util.*;

/**
 * Message represents the messages of dSelf. 
 */
public abstract class Message{   

  /** The receiver of this message. */
  protected dSelfObject receiver = null;
  
  /** The arguments of this message. */
  protected Vector messageArguments = null;
  
 /** 
  * All visited objects, it is needed by the lookup algorithm to
  * detect message cycling.
  */
  protected Hashtable visitedHash = new Hashtable();

 /**
  * Returns the selector (its name) of the message.
  */   
  public abstract String getSelector();
  
 /**
  * Checks, if this message is resend.
  */ 
  public abstract boolean isResend();
  
 /**
  * Checks, if this message is a directed resend.
  */ 
  public abstract boolean isDirectedResend();

 /**
  * Checks, if this message is an indirected resend.
  */ 
  public abstract boolean isIndirectedResend();

 /** 
  * Sets the receiver of this message.
  *
  * @param rec The receiver of this message
  * @return This message with the new receiver
  */
  public Message setReceiver(dSelfObject rec){
  
    receiver = rec;
    return this;
  }
  
 /**
  * Returns the receiver of this message.
  */ 
  public dSelfObject getReceiver(){
  
    return receiver;
  }
 
 /**
  * Adds an object, that was visited by the lookup algorithm.
  *
  * @param The object, that was visited
  * @return True when the object was visited twice
  */     
  public boolean addVisited(dSelfObject visit, String locationVM){
  
    Object set = visitedHash.get(locationVM);
    
    if (set != null && ((HashSet)set).contains(visit))
      return false;

    if (set == null) {
      set = new HashSet();
      visitedHash.put(locationVM, set);
    }
    ((HashSet)set).add(visit);
    
    return true;
  }
  
 /**
  * Removes this object from the visited list of this message.
  */ 
  public void removeVisited(dSelfObject visit, String locationVM){
  
    ((HashSet)visitedHash.get(locationVM)).remove(visit);
  }
      	  
 /**
  * Returns the number of arguments of this message.
  */	  
  public int getNumArgs(){
  
    return messageArguments.size();
  }  

 /**
  * Returns the first argument of this message.
  */ 
  public dSelfObject getFirstArg(){
  
    return (dSelfObject) messageArguments.firstElement();
  }  

 /**
  * Returns the second argument of this message.
  */ 
  public dSelfObject getSecondArg(){
  
    return (dSelfObject) messageArguments.get(1);
  }  

 /**
  * Returns the third argument of this message.
  */ 
  public dSelfObject getThirdArg(){
  
    return (dSelfObject) messageArguments.get(2);
  }  

 /**
  * Returns the fourth argument of this message.
  */ 
  public dSelfObject getFourthArg(){
  
    return (dSelfObject) messageArguments.get(3);
  }  

 /**
  * Returns the last argument of this message.
  */ 
  public dSelfObject getLastArg(){
  
    return (dSelfObject) messageArguments.lastElement();
  }  
    
 /**
  * Returns a vector with all arguments of this message.
  */   
  public Vector getArgs(){
  
    return messageArguments;
  }  

  /** If this is "value", "value:", "value:With:..." selector */
  public static boolean isBlockValueSelector(String selector) {

    if (selector.equals("value") || selector.equals("value:"))
      return true;

    if (selector.startsWith("value:")) {
      StringTokenizer tokenizer
	= new StringTokenizer(selector.substring("value:".length()), ":");
      String str;

      while (tokenizer.hasMoreTokens()) {
	str = tokenizer.nextToken();
	
	if (! str.equals("With"))
	  return false;
      }
      return true;
    } 
    else {
      return false;
    }
  }

}
