package dSelf;

import dSelfVM;

/**
 * DataSlotDecl represents the declaration of a data slot. It is used 
 * by the parser.
 */
public class DataSlotDecl extends SlotDecl{

  /** The content of this slot. */
  protected CodeExpr expression;

  /** Is this slot a parent slot ? */
  protected boolean isParent;

  /** Is the content of this slot assignable ? */
  protected boolean isAssignable;

  /** Is this slot an argument slot ? */
  protected boolean isArgument;
  
 /** 
  * Creates a new data slot declaration with the given characteristics. 
  */
  public DataSlotDecl(String name, boolean isPar, boolean isAssign,
      boolean isArg, CodeExpr expr, String anno){
      
    slotName = name;
    annotation = anno;
    isParent = isPar;
    isAssignable = isAssign;
    isArgument = isArg;
    expression = expr;
  }  
      
 /**
  * Checks, if this slot is a parent slot.
  */ 
  public boolean isParentSlot(){
  
    return isParent;
  }
  
 /**
  * Checks, if the content of this slot is assignable.
  */ 
  public boolean isAssignableSlot(){
  
    return isAssignable;
  }
  
 /**
  * Checks, if this slot is an argument slot.
  */ 
  public boolean isArgumentSlot(){
  
    return isArgument;
  }

 /**
  * Evaluates the content of this slot in the context of the lobby.
  *
  * @return The evaluated content of this data slot
  */ 
  public DataSO evalSlot() throws dSelfException, NonLocalReturnException{
  
    return expression.eval(dSelfVM.lobbySO);
  }    
}  
