package dSelf;

import dSelfVM;

/**
 * BlockSOExpr represents an not evaluated dSelf block object.
 */
public class BlockSOExpr implements CodeExpr{

  /** The method expression with the code of this block expression. */
  protected MethodSOExpr methodExpr;
  
  /** The method expression with the code of this block expression. */
  private BlockSO cachedBlockSO = null;
  
 /**
  * Creates a new block expression with the given method expression.
  *
  * @param mExpr The method expression with the code of this block
  */
  public BlockSOExpr(MethodSOExpr mExpr){
  
    methodExpr = mExpr;
  }
    
 /** 
  * Evaluates this block expression within the given context and returns 
  * the evaluated block.
  *
  * @param dSo The context, within this block expression is evaluated
  * @return The resulting dSelf block 
  * @see BlockSO
  */
  public DataSO eval(DataOrMethodSO dSO) 
      throws dSelfException, NonLocalReturnException{

    if (cachedBlockSO != null) {
      if (Globals.debug_lookupCache || Globals.debug_searchPath)
	dSelfVM.printMessage("....block reset context: "+dSO);
      
      cachedBlockSO.setContext(dSO);
      return cachedBlockSO;
    }else {
      if (Globals.debug_lookupCache || Globals.debug_searchPath)
	dSelfVM.printMessage("....create block with context: "+dSO);
      
      return cachedBlockSO = new BlockSO(methodExpr.evalForBlock(dSO));
    }
  }
}
