package dSelf;

import java.util.Vector;

/**
 * Assignment slots contain assignable dSelf objects. Assignment
 * slots are slots, that can assign new data objects to data slots.
 */
public class AssignmentSlot implements Slot{

  /** The name of this slot */
  protected String name;
  /** The annotation for this slot */
  protected String annotation = null;
  /** The content of this slot */
  protected AssignmentSO content;
  
 /** 
  * Creates a new assignment slot with the specified name and the
  * data slot, that shall be assignable.
  * 
  * @param n The name of this slot
  * @param s The data slot, where this assignment slot refers to
  */
  public AssignmentSlot(String n, DataSlot s){
  
    name = n;
    content = new LocalAssignmentSO(s);
  }

  /** Returns the name of this slot */
  public String getName(){
  
    return name;
  }

 /**
  * Returns the content of this slot.
  */ 
  public dSelfObject getContent(){
  
    return content;
  }

 /** 
  * Sets a new annotation for this slot. If an old annotation already
  * exists, then the new one is appended to the old one.
  */
  public void setAnnotation(String a){
  
    if(a != null)
      annotation = a + (annotation == null ? "": annotation);
  }
 
 /**
  * Returns the annotation for this slot. If no annotation exists, then
  * "No annotation available." is returned.
  */   
  public String getAnnotation(){
  
    return annotation == null ? "No annotation available." : annotation;
  }  
}      
